package nemosofts.voxradio.executor;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;

import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.interfaces.HomeListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemCountries;
import nemosofts.voxradio.item.ItemHomeSlider;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemPost;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.AsyncTaskExecutor;
import okhttp3.RequestBody;

public class LoadHome extends AsyncTaskExecutor<String, String, String> {

    RequestBody requestBody;
    HomeListener homeListener;
    ArrayList<ItemPost> arrayListPost = new ArrayList<>();
    String message = "";
    String successAPI = "1";

    private static final String TAG_ID = "id";
    private static final String TAG_CAT_ID = "cat_id";
    private static final String TAG_TITLE = "radio_title";
    private static final String TAG_URL = "radio_url";
    private static final String TAG_IMAGE = "image";
    private static final String TAG_AVG_RATE = "averageRating";
    private static final String TAG_TOTAL_RATE = "totalRate";
    private static final String TAG_CAT_NAME = "category_name";
    private static final String TAG_TOTAL_VIEWS = "total_views";
    private static final String TAG_PREMIUM = "is_premium";
    private static final String TAG_FAV = "is_favourite";

    private static final String TAG_POST_ID = "post_id";
    private static final String TAG_POST_TITLE = "post_title";
    private static final String TAG_POST_IMG = "post_image";

    public LoadHome(HomeListener homeListener, RequestBody requestBody) {
        this.homeListener = homeListener;
        this.requestBody = requestBody;
    }

    @Override
    protected void onPreExecute() {
        homeListener.onStart();
        super.onPreExecute();
    }

    @Override
    protected String doInBackground(String strings) {
        try {
            String json = ApplicationUtil.responsePost(Callback.API_URL, requestBody);
            JSONObject mainJson = new JSONObject(json);

            try {

                JSONObject jsonObject = mainJson.getJSONObject(Callback.TAG_ROOT);

                ItemPost itemPost;
                String postTitle;
                String postType;
                String postId;

                if (jsonObject.has("slider")) {

                    JSONArray jsonArrayBanner = jsonObject.getJSONArray("slider");

                    postTitle = "Home Banners";
                    postType = "slider";
                    itemPost = new ItemPost("", postTitle, postType, false);

                    ArrayList<ItemHomeSlider> arrayListBanner = new ArrayList<>();
                    for (int i = 0; i < jsonArrayBanner.length(); i++) {
                        JSONObject objJsonBanner = jsonArrayBanner.getJSONObject(i);

                        String bannerID = objJsonBanner.getString("bid");
                        String bannerTitle = objJsonBanner.getString("banner_title");
                        String bannerDesc = objJsonBanner.getString("banner_info");
                        String bannerImage = objJsonBanner.getString("banner_image").replace(" ", "%20");
                        if (bannerImage.isEmpty()) {
                            bannerImage = "null";
                        }

                        arrayListBanner.add(new ItemHomeSlider(bannerID, bannerTitle, bannerDesc, bannerImage));
                    }
                    itemPost.setArrayListBanner(arrayListBanner);
                    arrayListPost.add(itemPost);
                }

                if (jsonObject.has("recently_radio")) {

                    JSONArray jsonArrayRecent = jsonObject.getJSONArray("recently_radio");

                    if (jsonArrayRecent.length() > 0) {

                        postTitle = "Recently Played";
                        postType = "recent";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListRecent = new ArrayList<>();
                        for (int i = 0; i < jsonArrayRecent.length(); i++) {
                            JSONObject objJson = jsonArrayRecent.getJSONObject(i);

                            String id = objJson.getString(TAG_ID);
                            String catId = objJson.getString(TAG_CAT_ID);
                            String radioTitle = objJson.getString(TAG_TITLE);
                            String radioURL = objJson.getString(TAG_URL);
                            String image = objJson.getString(TAG_IMAGE).replace(" ", "%20");
                            if (image.isEmpty()) {
                                image = "null";
                            }
                            String averageRating = objJson.getString(TAG_AVG_RATE);
                            String totalRate = objJson.getString(TAG_TOTAL_RATE);
                            String catName = objJson.getString(TAG_CAT_NAME);
                            String totalViews = objJson.getString(TAG_TOTAL_VIEWS);
                            boolean isPremium = objJson.getBoolean(TAG_PREMIUM);
                            boolean isFav = objJson.getBoolean(TAG_FAV);

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,
                                    averageRating, totalRate, totalViews, catName, isPremium, isFav);
                            arrayListRecent.add(objItem);
                        }
                        itemPost.setArrayListRecently(arrayListRecent);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("latest_radio")) {

                    JSONArray jsonArrayLatest = jsonObject.getJSONArray("latest_radio");

                    if (jsonArrayLatest.length() > 0) {

                        postTitle = "latest radio";
                        postType = "latest";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListLatest = new ArrayList<>();
                        for (int i = 0; i < jsonArrayLatest.length(); i++) {
                            JSONObject objJson = jsonArrayLatest.getJSONObject(i);

                            String id = objJson.getString(TAG_ID);
                            String catId = objJson.getString(TAG_CAT_ID);
                            String radioTitle = objJson.getString(TAG_TITLE);
                            String radioURL = objJson.getString(TAG_URL);
                            String image = objJson.getString(TAG_IMAGE).replace(" ", "%20");
                            if (image.isEmpty()) {
                                image = "null";
                            }
                            String averageRating = objJson.getString(TAG_AVG_RATE);
                            String totalRate = objJson.getString(TAG_TOTAL_RATE);
                            String catName = objJson.getString(TAG_CAT_NAME);
                            String totalViews = objJson.getString(TAG_TOTAL_VIEWS);
                            boolean isPremium = objJson.getBoolean(TAG_PREMIUM);
                            boolean isFav = objJson.getBoolean(TAG_FAV);

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,
                                    averageRating, totalRate, totalViews, catName, isPremium, isFav);
                            arrayListLatest.add(objItem);
                        }
                        itemPost.setArrayListRadio(arrayListLatest);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("trending_radio")) {

                    JSONArray jsonArrayTrending = jsonObject.getJSONArray("trending_radio");

                    if (jsonArrayTrending.length() > 0) {

                        postTitle = "Trending Radio";
                        postType = "trending";
                        itemPost = new ItemPost("", postTitle, postType, false);

                        ArrayList<ItemRadio> arrayListTrending = new ArrayList<>();
                        for (int i = 0; i < jsonArrayTrending.length(); i++) {
                            JSONObject objJson = jsonArrayTrending.getJSONObject(i);

                            String id = objJson.getString(TAG_ID);
                            String catId = objJson.getString(TAG_CAT_ID);
                            String radioTitle = objJson.getString(TAG_TITLE);
                            String radioURL = objJson.getString(TAG_URL);
                            String image = objJson.getString(TAG_IMAGE).replace(" ", "%20");
                            if (image.isEmpty()) {
                                image = "null";
                            }
                            String averageRating = objJson.getString(TAG_AVG_RATE);
                            String totalRate = objJson.getString(TAG_TOTAL_RATE);
                            String catName = objJson.getString(TAG_CAT_NAME);
                            String totalViews = objJson.getString(TAG_TOTAL_VIEWS);
                            boolean isPremium = objJson.getBoolean(TAG_PREMIUM);
                            boolean isFav = objJson.getBoolean(TAG_FAV);

                            ItemRadio objItem = new ItemRadio(id, catId, radioTitle, radioURL, image,
                                    averageRating, totalRate, totalViews, catName, isPremium, isFav);
                            arrayListTrending.add(objItem);
                        }
                        itemPost.setArrayListTrending(arrayListTrending);
                        arrayListPost.add(itemPost);
                    }
                }

                if (jsonObject.has("home_sections")) {

                    JSONArray jsonArraySection = jsonObject.getJSONArray("home_sections");

                    for (int j = 0; j < jsonArraySection.length(); j++) {

                        JSONObject jObjHome = jsonArraySection.getJSONObject(j);

                        postId = jObjHome.getString("home_id");
                        postTitle = jObjHome.getString("home_title");
                        postType = jObjHome.getString("home_type");
                        itemPost = new ItemPost(postId, postTitle, postType , true);

                        JSONArray jsonArrayHomeContent = jObjHome.getJSONArray("home_content");

                            switch (postType) {
                                case "category":
                                    ArrayList<ItemCat> arrayListCat = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString(TAG_POST_ID);
                                        String name = objJson.getString(TAG_POST_TITLE);
                                        String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                                        if (image.isEmpty()) {
                                            image = "null";
                                        }

                                        ItemCat itemCat = new ItemCat(id, name, image);
                                        arrayListCat.add(itemCat);
                                    }
                                    itemPost.setArrayListCategories(arrayListCat);
                                    break;

                                case "countries":
                                    ArrayList<ItemCountries> arrayListPlaylist = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString(TAG_POST_ID);
                                        String name = objJson.getString(TAG_POST_TITLE);
                                        String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                                        if (image.isEmpty()) {
                                            image = "null";
                                        }

                                        ItemCountries itemCountries = new ItemCountries(id, name, image);
                                        arrayListPlaylist.add(itemCountries);
                                    }
                                    itemPost.setArrayListCountries(arrayListPlaylist);
                                    break;

                                case "podcasts":
                                    ArrayList<ItemPodcasts> arrayListArtist = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString(TAG_POST_ID);
                                        String name = objJson.getString(TAG_POST_TITLE);
                                        String image = objJson.getString(TAG_POST_IMG).replace(" ", "%20");
                                        if (image.isEmpty()) {
                                            image = "null";
                                        }

                                        ItemPodcasts objItem = new ItemPodcasts(id, name, image);
                                        arrayListArtist.add(objItem);
                                    }
                                    itemPost.setArrayListPodcasts(arrayListArtist);
                                    break;

                                case "radio":
                                    ArrayList<ItemRadio> arrayListRadio = new ArrayList<>();
                                    for (int i = 0; i < jsonArrayHomeContent.length(); i++) {
                                        JSONObject objJson = jsonArrayHomeContent.getJSONObject(i);

                                        String id = objJson.getString(TAG_ID);
                                        String catId = objJson.getString(TAG_CAT_ID);
                                        String radioTitle = objJson.getString(TAG_TITLE);
                                        String radioURL = objJson.getString(TAG_URL);
                                        String image = objJson.getString(TAG_IMAGE).replace(" ", "%20");
                                        if (image.isEmpty()) {
                                            image = "null";
                                        }
                                        String averageRating = objJson.getString(TAG_AVG_RATE);
                                        String totalRate = objJson.getString(TAG_TOTAL_RATE);
                                        String catName = objJson.getString(TAG_CAT_NAME);
                                        String totalViews = objJson.getString(TAG_TOTAL_VIEWS);
                                        boolean isPremium = objJson.getBoolean(TAG_PREMIUM);
                                        boolean isFav = objJson.getBoolean(TAG_FAV);

                                        ItemRadio objItem = new ItemRadio(id, catId, radioTitle,
                                                radioURL, image, averageRating, totalRate, totalViews,
                                                catName, isPremium, isFav);
                                        arrayListRadio.add(objItem);
                                    }
                                    itemPost.setArrayListRadio(arrayListRadio);
                                    break;
                                default:
                                    break;
                            }
                            arrayListPost.add(itemPost);
                        }
                }

            } catch (Exception e) {
                JSONArray jsonArray = mainJson.getJSONArray(Callback.TAG_ROOT);
                JSONObject jsonObject = jsonArray.getJSONObject(0);
                successAPI = jsonObject.getString(Callback.TAG_SUCCESS);
                message = jsonObject.getString(Callback.TAG_MSG);
            }
            return "1";
        } catch (Exception e) {
            return "0";
        }
    }

    @Override
    protected void onPostExecute(String s) {
        homeListener.onEnd(s, message, arrayListPost);
    }
}